﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Threading.Tasks;
using System.Windows;

namespace AZVIC.Ei8htPOS.POSRetail
{
    /// <summary>
    /// Interaction logic for App.xaml
    /// </summary>
    public partial class App : Application
    {
        private void Application_DispatcherUnhandledException(object sender, System.Windows.Threading.DispatcherUnhandledExceptionEventArgs e)
        {
            #if !DEBUG
            MessageBox.Show("An un handled exception just occurred. Please contact the administrator for help.", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error);
            Constants.AppSession.CurrentOrders = null;
            Constants.AppSession.CurrentUser = null;
            e.Handled = true;
            #endif
        }

        public static bool ConfirmationDialog(string ContentText, string HeaderText)
        {
            if (MessageBox.Show(ContentText, HeaderText, MessageBoxButton.YesNo, MessageBoxImage.Warning) == MessageBoxResult.Yes)
            {
                return true;
            }
            return false;
        }

        public static void ShowMessageBox(string ContentText, string HeaderText)
        {
            MessageBox.Show(ContentText, HeaderText, MessageBoxButton.OK, MessageBoxImage.Information);
        }

        public static void ShowErrorMessageBox(string ContentText, string HeaderText)
        {
            MessageBox.Show(ContentText, HeaderText, MessageBoxButton.OK, MessageBoxImage.Error);
        }
    }
}
